package cn.com.duiba.bigdata.online.service.api.remoteservice;

import cn.com.duiba.bigdata.online.service.api.dto.DropWaterAppMappingDto;
import cn.com.duiba.bigdata.online.service.api.dto.DropWaterNeedDataDto;
import cn.com.duiba.bigdata.online.service.api.dto.DropWaterNeedDataPage;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * 水滴服务-规则分，规则指标数据
 */
@AdvancedFeignClient
public interface RemoteDropWaterService {

    //回传水滴-规则数据-需要分页处理
    List<DropWaterNeedDataDto> dropWaterRule(List<String> accountIds, String curDate, Integer currentPage, Integer pageSize);

    //分页问题
    DropWaterNeedDataPage dropWaterRules(List<String> accountIds, String curDate, Integer currentPage, Integer pageSize);

    //流量id-对应的映射关系
    List<DropWaterAppMappingDto> dropWaterAppMapping(List<String> appIds, String curDate);

}
