package cn.com.duiba.bigdata.service.api.form;

import lombok.Data;

import java.util.List;


/**
 * 支付宝订单entity
 */
@Data
public class AlipayOrderFrom {
    /**
     * 日期列表 yyyy-MM-dd
     */
    private List<String> dates;
    /**
     * 媒体id
     */
    private List<Long> appIds;
    /**
     * 广告位id
     */
    private List<Long> slotIds;
    /**
     * 活动id
     */
    private List<Long> activityIds;
    /**
     * 订单状态
     */
    private List<Long> orderStatus;
    /**
     * 活动类型
     * 1: <2000 活动 2: >=2000 插件
     */
    private int activityType;
    /**
     * 奖品类型
     */
    private List<Long> alipayType;
    /**
     * 页数
     */
    private int page;
    /**
     * 每页条数
     */
    private int size;

}
