package cn.com.duiba.bigdata.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xugf 2019-08-21
 */
@Data
public class DuibaRiskDto implements Serializable {

    private static final long serialVersionUID = 235146216900768380L;

    //用户id
    private String consumerId;

    //支付宝账号
    private String alipayAccount;

    //ua或者os，全部用ua字段表示
    private String uaMd5;

    //用户ip
    private String ip;

    //用户ip前3段地址
    private String ip3;

    //媒体id
    private String appId;

    //活动id 以活动长id为主，如果没有长id，取活动短id
    private String activityId;

    //活动类型
    private String activityType;

    //天粒度的时间
    private String dayTime;

    //分钟粒度的时间
    private List<String> minuteTimeList;

    //访问次数
    private Long pv = 0L;

    //用户关联的ip个数（去重）
    private Long ipUv = 0L;

    //用户关联的ua个数（去重）
    private Long uaUv = 0L;

    //用户关联的支付宝个数（去重）
    private Long alipayUv = 0L;

    //支付宝关联的用户id个数（去重）
    private Long consumerUv = 0L;

    //ua是否包含windows/os是否包含windows或者mac   0:不包含  1:包含
    private String isWindows;
}
