package cn.com.duibabiz.component.filters.bloom.url;

import cn.com.duiba.wolf.entity.Pair;

import java.util.Optional;

/**
 * 存储接口顺序调用拦截的标志
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/16 11:23
 */
public class UrlSerialAccessLocal {
    /**
     * key:true-已访问，false-未访问
     * value:未访问的
     */
    private static final ThreadLocal<Pair<Boolean, String>> LOCAL = new ThreadLocal<>();

    public static Pair<Boolean, String> get() {
        return LOCAL.get();
    }

    public static void set(Pair<Boolean, String> pair) {
        LOCAL.set(pair);
    }

    public static void clear() {
        LOCAL.remove();
    }

    /**
     * 是否已访问
     *
     * @return true-是，false-不是，需要拦截
     */
    public static boolean hasRecord() {
        return Optional.ofNullable(get())
                .map(Pair::getKey)
                .orElse(true);
    }

}
