package cn.com.duibabiz.component.filters.bloom.url.interceptor;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import cn.com.duibabiz.component.filters.bloom.url.factory.PathParserFactory;
import cn.com.duibabiz.component.filters.bloom.url.path.PathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 记录下用户的访问
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/19 11:13
 */
public class PathRecordInterceptor implements HandlerInterceptor {
    public static final Logger LOGGER = LoggerFactory.getLogger(PathRecordInterceptor.class);

    @Resource
    private UrlSerialAccessFilter urlSerialAccessFilter;
    @Resource
    private PathParserFactory pathParserFactory;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Long cid = RequestLocal.getCid();
        String uri = request.getRequestURI();
        try {
            PathParser pathParser = pathParserFactory.getHandler(uri);
            if (pathParser != null) {
                urlSerialAccessFilter.record(pathParser, cid);
            } else {
                LOGGER.warn("urlSerialAccessService,record,pathParser is NULL,cid={},path={}", cid, uri);
            }
        } catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,record,exception,cid={},path={}", cid, uri, e);
        }

    }
}
