/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.util;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentificationTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentificationTool.class);
    private static final int VERSION = 1;
    private static final int BIGINT = 36;
    private static Pattern cidReg = Pattern.compile("^1[0-9A-Za-z]+");

    private IdentificationTool() {
    }

    public static String getEncryptCid(Long consumerId) {
        StringBuilder sb = new StringBuilder();
        if (consumerId > 0L) {
            sb.append(1);
            sb.append(new BigInteger(String.valueOf(consumerId * 2L + 56L), 10).toString(36));
        }
        return sb.toString();
    }

    public static Long getDecryptCid(String encryptCid) {
        if (StringUtils.isEmpty((String)encryptCid)) {
            return null;
        }
        try {
            String newEncryptCid = encryptCid.substring(1, encryptCid.length());
            long reInt = Long.parseLong(new BigInteger(newEncryptCid, 36).toString(10));
            reInt = (reInt - 56L) / 2L;
            return reInt > 0L ? reInt : 0L;
        }
        catch (Exception e) {
            LOGGER.warn("\u89e3\u6790\u52a0\u5bc6id\u5931\u8d25,encryptCid={}", (Object)encryptCid);
            return null;
        }
    }

    public static boolean validateEncryptCid(String encryptCid) {
        if (StringUtils.isEmpty((String)encryptCid)) {
            return false;
        }
        return cidReg.matcher(encryptCid).matches();
    }
}

