/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.oss;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="oss")
public class OssProperties {
    private String endPoint;
    private String bucketName;
    private static final String uploadPath = "oss/upload";
    private static final String appendUploadPath = "oss/uploadAppend";
    private static final String downloadPath = "oss/download";
    private static final String existPath = "oss/exist";
    private static final String sceneDetectionPath = "inspect/image";
    public static final String devBuckName = "daily-duiba";
    public static final String testBuckName = "daily-duiba";
    public static final String preBuckName = "duiba";
    public static final String prodBuckName = "duiba";

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() throws BizException {
        if (StringUtils.isNotBlank((CharSequence)this.bucketName)) {
            return this.bucketName;
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return "daily-duiba";
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return "daily-duiba";
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return "duiba";
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return "duiba";
        }
        throw new BizException("\u8bf7\u68c0\u67e5bucketName");
    }

    public String getUploadUrl() {
        return this.getEndPoint() + uploadPath;
    }

    public String getDownloadUrl() {
        return this.getEndPoint() + downloadPath;
    }

    public String getAppendUploadUrl() {
        return this.getEndPoint() + appendUploadPath;
    }

    public String getExistUrl() {
        return this.getEndPoint() + existPath;
    }

    public String getSceneDetectionUrl() {
        return this.getEndPoint() + sceneDetectionPath;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }
}

