package cn.com.duiba.biz.tool.duiba.mq;

import cn.com.duiba.biz.tool.duiba.enums.HttpRequestResultType;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;

/**
 * @author zhangruofan
 * @date 2018/07/13
 */
public class ValidatePrizeTagMsgDto implements Serializable {

    /**
     * http消息请求完成:发奖失败
     */
    public static final int GIVE_PRIZE_SUCCESS = 1;
    /**
     * http消息请求完成:发奖成功
     */
    public static final int GIVE_PRIZE_FAIL = 0;
    /**
     * 请求类型:get
     */
    public static final int HTTP_GET = 1;
    /**
     * 请求类型:post
     */
    public static final int HTTP_POST = 2;
    private static final long serialVersionUID = 6331976930454732569L;

    /**
     * appid
     */
    private Long appid;

    /**
     *应用唯一标识
     */
    private String appKey;

    private String appSecret;

    /**
     * 开发者接口
     */
    private String apiUrl;

    /**
     * 用户uid（开发者方）
     */
    private String uid;

    /**
     * 活动id
     */
    private Long actId;

    /**
     * 奖项标识符
     */
    private String prizeMark;

    /**
     * 是否发奖 0不发奖 1 发奖
     */
    private Integer givePrize;

    /**
     * 扩展参数
     */
    private Map<String, String> params;
    /**
     * 回调类型
     */
    private HttpRequestResultType resultType; // failed,completed,cancelled
    /**
     * mq回调topic
     */
    private String callbackTopic;
    /**
     * mq回调tag
     */
    private String callbackTag;
    /**
     * mq回调key
     */
    private String callbackKey;

    public Long getAppid() {
        return appid;
    }

    public void setAppid(Long appid) {
        this.appid = appid;
    }

    public String getPrizeMark() {
        return prizeMark;
    }

    public void setPrizeMark(String prizeMark) {
        this.prizeMark = prizeMark;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Long getActId() {
        return actId;
    }

    public void setActId(Long actId) {
        this.actId = actId;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getCallbackTopic() {
        return callbackTopic;
    }

    public void setCallbackTopic(String callbackTopic) {
        this.callbackTopic = callbackTopic;
    }

    public String getCallbackTag() {
        return callbackTag;
    }

    public void setCallbackTag(String callbackTag) {
        this.callbackTag = callbackTag;
    }

    public String getCallbackKey() {
        return callbackKey;
    }

    public void setCallbackKey(String callbackKey) {
        this.callbackKey = callbackKey;
    }

    public Integer getGivePrize() {
        return givePrize;
    }

    public void setGivePrize(Integer givePrize) {
        this.givePrize = givePrize;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public HttpRequestResultType getResultType() {
        return resultType;
    }

    public void setResultType(HttpRequestResultType resultType) {
        this.resultType = resultType;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static ValidatePrizeTagMsgDto decode(byte[] msg) {
        String body = new String(msg, Charset.forName("utf-8"));
        return JSONObject.parseObject(body, ValidatePrizeTagMsgDto.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param validatePrizeTagMsg
     * @return
     */
    public static byte[] encode(ValidatePrizeTagMsgDto validatePrizeTagMsg) {
        String string = JSONObject.toJSONString(validatePrizeTagMsg);
        return string.getBytes(Charset.forName("utf-8"));
    }
}
