package cn.com.duibabiz.component.token;

/**
 * Created by HePeng on 2018/12/11 16:04.
 */
public interface TokenService {
    /**
     * 获取表单token，没有则重新生成并缓存起来（缓存key根据consumerId生成）
     * @param consumerId
     * @return
     */
    String getAndCacheSecretToken(Long consumerId);

    /**
     * 获取表单token，没有则重新生成并缓存起来（定制缓存key，缓存key通过参数传入）
     * @param customizedCacheKey
     * @return
     */
    String getAndCacheSecretToken(String customizedCacheKey);

    /**
     * 获取混淆token（缓存key根据consumerId生成）
     * @param consumerId
     * @param referer
     * @return
     */
    String getConfusedToken(Long consumerId, String referer);

    /**
     * 获取混淆token（定制缓存key，缓存key通过参数传入）
     * @param consumerId
     * @param referer
     * @param customizedCacheKey
     * @return
     */
    String getConfusedToken(Long consumerId, String referer, String customizedCacheKey);

    /**
     * 校验真正的token（缓存key根据consumerId生成）
     * @param consumerId
     * @param token
     * @return
     */
    boolean checkAndInvalidConsumerToken(Long consumerId, String token);

    /**
     * 校验真正的token（定制缓存key，缓存key通过参数传入）
     * @param customizedCacheKey
     * @param token
     * @return
     */
    boolean checkAndInvalidConsumerToken(String customizedCacheKey, String token);
}
