package cn.com.duiba.biz.tool.duiba.util;


import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.wolf.utils.SecurityUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.stream.IntStream;

/**
 * Created by HePeng on 2018/12/11 16:51.
 */
public class DuibaTokenUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuibaTokenUtil.class);

    private static final int TOKEN_MIN_LENGTH = 5;
    private static final int TOKEN_RANDOM_RANGE_EXCLUSIVE = 5;
    private static final String RANDOM_STRING_BASE = "abcdefghijklmnopqrstuvwxyz0123456789";

    private static final String ERROR_SECRET_TOKEN_KEY = "uiiosaidnbua";
    private static final String TOKEN_KEY_START = "t";
    private static final int TOKEN_KEY_LENGTH = 8;

    private static final int DUMMY_TOKEN_RANGE_EXCLUSIVE = 10000000;

    /**
     * 生成token
     * @return
     */
    public static String genToken() {
        return getRandomString(TOKEN_MIN_LENGTH + RandomUtils.nextInt(TOKEN_RANDOM_RANGE_EXCLUSIVE));
    }

    /**
     * 根据用户id获取token对应的key
     * @param consumerId
     * @return
     */
    public static String getSecretTokenKey(Long consumerId) {
        return getTokenKey(String.valueOf(consumerId));
    }

    /**
     * 根据用户id获取token对应的key
     * @return
     */
    public static String getSecretTokenKey() {
        return getSecretTokenKey(RequestLocal.getCid());
    }

    /**
     * 生成混淆token的key（以0开头，防止和consumerId重复）
     * @return
     */
    public static String genDummyTokenKey() {
        return getTokenKey("0" + RandomUtils.nextInt(DUMMY_TOKEN_RANGE_EXCLUSIVE));
    }

    /**
     * 生成token的key
     * @param val
     * @return
     */
    private static String getTokenKey(String val) {
        if(val == null) {
            return ERROR_SECRET_TOKEN_KEY;
        }
        try {
            String md5 = SecurityUtils.encode2StringByMd5(val);
            return TOKEN_KEY_START + md5.substring(md5.length() - (TOKEN_KEY_LENGTH - TOKEN_KEY_START.length()));
        } catch (Exception e) {
            LOGGER.warn("获取key失败，val={}", val, e);
        }
        return ERROR_SECRET_TOKEN_KEY;
    }

    /**
     * 生成指定长度的随机字符串
     * @param length
     * @return
     */
    private static String getRandomString(int length) {
        StringBuilder sb = new StringBuilder();
        IntStream.range(0, length).forEach(
                i -> sb.append(RANDOM_STRING_BASE.charAt(RandomUtils.nextInt(RANDOM_STRING_BASE.length())))
        );
        return sb.toString();
    }


}
