/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.daily;

import cn.com.duiba.wolf.entity.Pair;
import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;

public class DailyKeyUtil {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.BASIC_ISO_DATE;

    public static String getTodayKey(String userKey) {
        return DailyKeyUtil.combineKey(userKey, LocalDate.now());
    }

    private static String combineKey(String userKey, LocalDate localDate) {
        return userKey + localDate.format(DATE_TIME_FORMATTER);
    }

    public static Pair<String, LocalDate> splitKey(String key) {
        int formatterLength = 8;
        return Pair.from((Object)key.substring(0, key.length() - formatterLength), (Object)LocalDate.parse(key.substring(key.length() - formatterLength), DATE_TIME_FORMATTER));
    }

    public static Set<String> getRecentlyKeys(String userKey, int recentlyDays) {
        LocalDate now = LocalDate.now();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i = 0; i < recentlyDays; ++i) {
            set.add(DailyKeyUtil.combineKey(userKey, now.minusDays(i)));
        }
        return set;
    }

    public static Date getExpireAt(Integer recordKeepDays) {
        recordKeepDays = Math.max(recordKeepDays, 1);
        return new Date(LocalDate.now().plusDays(recordKeepDays - 1).atTime(23, 59, 59, 59).toInstant(ZoneOffset.of("+8")).toEpochMilli());
    }

    public static void main(String[] args) {
        String userKey = "userKey";
        String todayKey = DailyKeyUtil.getTodayKey(userKey);
        System.out.println(todayKey);
        Pair<String, LocalDate> pair = DailyKeyUtil.splitKey(todayKey);
        Assert.isTrue((boolean)Objects.equals(userKey, pair.getKey()), (String)"key \u62c6\u5206\u9519\u8bef");
        Assert.isTrue((boolean)LocalDate.now().isEqual((ChronoLocalDate)pair.getValue()), (String)"key \u62c6\u5206\u9519\u8bef");
        Set<String> recentlyKeys = DailyKeyUtil.getRecentlyKeys(userKey, 2);
        System.out.println(JSON.toJSONString(recentlyKeys));
        String[] strings = recentlyKeys.toArray(new String[0]);
        for (int i = 0; i < strings.length; ++i) {
            String recentlyKey = strings[i];
            Pair<String, LocalDate> splitKey = DailyKeyUtil.splitKey(recentlyKey);
            Assert.isTrue((boolean)Objects.equals(userKey, splitKey.getKey()), (String)"key \u62c6\u5206\u9519\u8bef");
            Assert.isTrue((boolean)LocalDate.now().minusDays(i).isEqual((ChronoLocalDate)splitKey.getValue()), (String)"key \u62c6\u5206\u9519\u8bef");
        }
        Date expireAt = DailyKeyUtil.getExpireAt(1);
        System.out.println(expireAt.getTime());
        Assert.isTrue((expireAt.getTime() == LocalDate.now().atTime(23, 59, 59, 59).toInstant(ZoneOffset.of("+8")).toEpochMilli() ? 1 : 0) != 0, (String)"key \u62c6\u5206\u9519\u8bef");
        expireAt = DailyKeyUtil.getExpireAt(2);
        System.out.println(expireAt.getTime());
        Assert.isTrue((expireAt.getTime() == LocalDate.now().plusDays(1L).atTime(23, 59, 59, 59).toInstant(ZoneOffset.of("+8")).toEpochMilli() ? 1 : 0) != 0, (String)"key \u62c6\u5206\u9519\u8bef");
    }
}

