/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.domain;

import cn.com.duiba.developer.center.api.remoteservice.RemoteDomainConfigService;
import cn.com.duibabiz.component.domain.DomainService;
import cn.com.duibabiz.component.domain.ResponseBodyDomainHander;
import cn.com.duibabiz.component.domain.impl.DomainServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"duiba.domain.service.enable"}, havingValue="true")
@ConditionalOnClass(value={RemoteDomainConfigService.class})
@Configuration
public class DomainAutoConfig {
    @Autowired
    private RemoteDomainConfigService remoteDomainConfigService;
    @Value(value="${duiba.service.domain://activity.m.duiba.com.cn}")
    private String serviceDomain;
    @Value(value="${duiba.tuia.domain://activity.tuistone.com}")
    private String tuiaDomain;
    @Value(value="${duiba.cdn.domain://yun.duiba.com.cn}")
    private String cdnDomain;
    @Value(value="${spring.profiles.active:prodvpc}")
    private String env;

    @Bean(name={"domainService"})
    public DomainService domainService() {
        DomainServiceImpl domainService = new DomainServiceImpl(this.remoteDomainConfigService, this.serviceDomain, this.tuiaDomain, this.cdnDomain);
        return domainService;
    }

    @ConditionalOnProperty(name={"duiba.domain.rspbody.handle.enable"}, havingValue="true")
    @Bean
    public ResponseBodyDomainHander responseBodyDomainHander() {
        return new ResponseBodyDomainHander(this.domainService(), this.env);
    }
}

