package cn.com.duibabiz.component.filters.bloom.daily;

import cn.com.duibabiz.component.filters.bloom.basic.RedisBloomFilter;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/19 17:54
 */
@Configuration
public class BasicConConfig {
    @Bean
    public UrlSerialAccessFilter urlSerialAccessFilter(DailyRedisBloomFilter dailyRedisBloomFilter) {
        return new UrlSerialAccessFilter(dailyRedisBloomFilter);
    }

    /**
     * 默认配置
     * 保存两天=今天+明天
     */
    @Bean
    @ConditionalOnMissingBean(DailyRedisBloomFilter.class)
    public DailyRedisBloomFilter dailyRedisBloomFilter(RedisBloomFilter redisBloomFilter) {
        return new DailyRedisBloomFilter(2, redisBloomFilter);
    }

    /**
     * 默认配置
     * 5000并发buffer
     * 20w容量
     * 万分之一假阳性
     */
    @Bean
    @ConditionalOnMissingBean(RedisBloomFilter.class)
    public RedisBloomFilter redisBloomFilter() {
        return new RedisBloomFilter(5000, 200_000, 0.001);
    }
}
