/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.email;

import cn.com.duibabiz.component.email.DuibaEmailProperties;
import cn.com.duibabiz.component.email.DuibaSendEmailBean;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class DuibaEmailHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DuibaEmailHelper.class);
    @Autowired
    private JavaMailSender sender;
    @Autowired
    private DuibaEmailProperties duibaEmailProperties;

    public boolean sendEmail(DuibaSendEmailBean emailBean) {
        List<String> toUsers = emailBean.getToUsers();
        if (CollectionUtils.isEmpty(toUsers)) {
            throw new IllegalArgumentException("\u63a5\u6536\u4eba\u7684\u90ae\u7bb1\u5730\u5740\u5fc5\u586b");
        }
        try {
            MimeMessage mail = this.sender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mail);
            helper.setTo(toUsers.toArray(new String[toUsers.size()]));
            helper.setSubject(emailBean.getSubject());
            helper.setFrom(this.duibaEmailProperties.getUsername());
            helper.setText(emailBean.getContent(), emailBean.getIsHtml());
            this.sender.send(mail);
            return true;
        }
        catch (Exception e) {
            LOG.error("\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38,emailBean={}", (Object)JSONObject.toJSONString((Object)emailBean), (Object)e);
            return false;
        }
    }
}

