package cn.com.duiba.biz.tool.duiba.dto;

import cn.com.duiba.biz.tool.duiba.enums.LotteryRankBizTypeEnum;
import cn.com.duiba.biz.tool.duiba.enums.LotteryRankObtainTypeEnum;
import org.apache.commons.lang.builder.HashCodeBuilder;

import java.io.Serializable;
import java.util.Objects;

/**
 * Created by wangfan 2018/6/7
 */
public class LotteryRankDto implements Serializable {

    private static final long serialVersionUID = 774496562463848942L;

    private Long id;

    private Long appId;

    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 业务类型 0活动组 1活动
     */
    private LotteryRankBizTypeEnum bizType;

    private Long consumerId;

    /**
     * 累计赢得的奖励
     */
    private Long totalObtain;

    /**
     * 获胜次数
     */
    private Integer winTimes;

    /**
     * 奖励类型 0积分
     */
    private LotteryRankObtainTypeEnum obtainType;

    private Integer index;

    private Integer deleted;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getBizId() {
        return bizId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getTotalObtain() {
        return totalObtain;
    }

    public void setTotalObtain(Long totalObtain) {
        this.totalObtain = totalObtain;
    }

    public Integer getWinTimes() {
        return winTimes;
    }

    public void setWinTimes(Integer winTimes) {
        this.winTimes = winTimes;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public LotteryRankBizTypeEnum getBizType() {
        return bizType;
    }

    public void setBizType(LotteryRankBizTypeEnum bizType) {
        this.bizType = bizType;
    }

    public LotteryRankObtainTypeEnum getObtainType() {
        return obtainType;
    }

    public void setObtainType(LotteryRankObtainTypeEnum obtainType) {
        this.obtainType = obtainType;
    }

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this, false);
    }

    @Override
    public boolean equals(Object obj) {
        if(obj instanceof LotteryRankDto){
            LotteryRankDto lotteryRankDto = (LotteryRankDto) obj;
            if(Objects.equals(bizId,lotteryRankDto.getBizId()) && Objects.equals(bizType,lotteryRankDto.getBizType())
                    && Objects.equals(consumerId,lotteryRankDto.getConsumerId())){
                return true;
            }
        }
        return false;
    }
}
