package cn.com.duibabiz.component.redis;

import org.springframework.boot.context.properties.ConfigurationProperties;

import javax.validation.constraints.DecimalMin;

/**
 * Created by zhenghuan on 2019/3/11.
 * 技术方案地址:http://cf.dui88.com/pages/viewpage.action?pageId=22289794
 */
@ConfigurationProperties(prefix = "duiba.custom.redis")
public class RedisCustomClientProperties {
    /**
     * keys最大个数,超过这个个数会拒绝服务
     */
    @DecimalMin(value = "1")
    private Integer keysMax = 800;

    /**
     * 一次拆分个数
     * 1.单个redis大概是50个,兑吧线上有8个节点,所以这里选择50*8=400
     */
    @DecimalMin(value = "1")
    private Integer split = 400;

    public Integer getKeysMax() {
        return keysMax;
    }

    public void setKeysMax(Integer keysMax) {
        this.keysMax = keysMax;
    }

    public Integer getSplit() {
        return split;
    }

    public void setSplit(Integer split) {
        this.split = split;
    }
}
