package cn.com.duibabiz.component.email;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

import java.util.Properties;

/**
 * Created by sunchangji on 2019/3/11.
 */
@Configuration
@ConditionalOnClass({JavaMailSender.class,javax.mail.internet.MimeMessage.class})
@EnableConfigurationProperties(DuibaEmailProperties.class)
public class DuibaEmailAutoConfiguration {

	@Autowired
	private DuibaEmailProperties duibaEmailProperties;

	@Bean(name = "javaMailSender")
	public JavaMailSender javaMailSender(){
		JavaMailSenderImpl sender = new JavaMailSenderImpl();
		sender.setHost(duibaEmailProperties.getHost());
		sender.setPort(duibaEmailProperties.getPort());
		sender.setProtocol(duibaEmailProperties.getProtocol());
		sender.setDefaultEncoding(duibaEmailProperties.getDefaultEncoding());
		sender.setUsername(duibaEmailProperties.getUsername());
		sender.setPassword(duibaEmailProperties.getPassword());
		Properties props = new Properties();
		props.put("mail.smtp.auth", "true");
		props.put("mail.smtp.ssl.enable",true);
		props.put("mail.smtp.socketFactory.port", 465);
		props.put("mail.smtp.timeout", 30000);
		props.put("mail.smtp.socketFactory.class", javax.net.ssl.SSLSocketFactory.class);
		props.put("mail.smtp.socketFactory.fallback", false);
		props.put("mail.smtp.quitwait",false);
		sender.setJavaMailProperties(props);

		return sender;
	}

	@Bean
	public DuibaEmailHelper duibaEmailHelper(@Qualifier(value = "javaMailSender") JavaMailSender sender){
		return new DuibaEmailHelper();
	}
}
