package cn.com.duibabiz.component.filters.bloom.basic;


import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

import java.util.Date;
import java.util.List;

/**
 * 位图操作工具，支持pipeline
 *
 * @author zengsp
 */
public class BitMapUtil {
    /**
     * 计算位图1的数量
     */
    public static Long bitCount(StringRedisTemplate stringRedisTemplate, String filterKey) {
        return stringRedisTemplate.execute((RedisCallback<Long>) connection -> connection.bitCount(filterKey.getBytes()));
    }

    public static boolean mightContainWithPipeline(StringRedisTemplate stringRedisTemplate, String filterKey, int[] offset) {
        List<Object> objects = stringRedisTemplate.executePipelined((RedisCallback<Boolean>) connection -> {
            byte[] rawKey = getBytes(stringRedisTemplate, filterKey);
            for (int i : offset) {
                connection.getBit(rawKey, i);
            }
            return null;
        });


        for (Object object : objects) {
            if (!(Boolean) object) {
                // 有一个函数判断不存在则不存在
                return false;
            }
        }

        return true;
    }


    public static void putWithPipeline(StringRedisTemplate stringRedisTemplate, String filterKey, int[] offset, Date expireAt) {
        stringRedisTemplate.executePipelined((RedisCallback<String>) connection -> {

            byte[] rawKey = getBytes(stringRedisTemplate, filterKey);
            // 依次写入位
            for (int i : offset) {
                connection.setBit(rawKey, i, true);
            }

            if (expireAt != null) {
                connection.expireAt(rawKey, expireAt.getTime() / 1000);
            }

            return null;
        });
    }

    private static byte[] getBytes(StringRedisTemplate stringRedisTemplate, String filterKey) {
        return ((RedisSerializer<String>) stringRedisTemplate.getKeySerializer()).serialize(filterKey);
    }

}
