package cn.com.duibabiz.component.redis;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2019/6/3 0003 15:33
 */

/**
 * @param <K>
 * @param <V>
 * @see RedisCustomClientProperties
 */
public interface RedisCustomClient<K, V> {
    /**
     * Set the {@code value} and expiration {@code timeout} for {@code key}.
     *
     * @param key     must not be {@literal null}.
     * @param value
     * @param timeout
     * @param unit    must not be {@literal null}.
     * @see <a href="http://redis.io/commands/setex">Redis Documentation: SETEX</a>
     */
    void set(K key, V value, long timeout, TimeUnit unit);

    /**
     * Set {@code key} to hold the string {@code value} if {@code key} is absent.
     *
     * @param key   must not be {@literal null}.
     * @param value
     * @see <a href="http://redis.io/commands/setnx">Redis Documentation: SETNX</a>
     */
    Boolean setIfAbsent(K key, V value);

    /**
     * Get the value of {@code key}.
     *
     * @param key must not be {@literal null}.
     * @see <a href="http://redis.io/commands/get">Redis Documentation: GET</a>
     */
    V get(Object key);

    /**
     * Get multiple {@code keys}. Values are returned in the order of the requested keys.
     *
     * @param keys must not be {@literal null}.
     * @see <a href="http://redis.io/commands/mget">Redis Documentation: MGET</a>
     */
    /**
     * multiGet操作不能默认不能超过RedisCustomClientProperties.keysMax值.超过会报错
     * 如果有特别需要可以修改RedisCustomClientProperties对应值
     */
    List<V> multiGet(Collection<K> keys);

    /**
     * Increment an integer value stored as string value under {@code key} by {@code delta}.
     *
     * @param key   must not be {@literal null}.
     * @param delta
     * @see <a href="http://redis.io/commands/incr">Redis Documentation: INCR</a>
     */
    Long increment(K key, long delta);

    /**
     * Increment a floating point number value stored as string value under {@code key} by {@code delta}.
     *
     * @param key   must not be {@literal null}.
     * @param delta
     * @see <a href="http://redis.io/commands/incrbyfloat">Redis Documentation: INCRBYFLOAT</a>
     */
    Double increment(K key, double delta);

    /**
     * Set time to live for given {@code key}..
     *
     * @param key     must not be {@literal null}.
     * @param timeout
     * @param unit    must not be {@literal null}.
     * @return
     */
    Boolean expire(K key, long timeout, TimeUnit unit);
}
