/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.util;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA256Util {
    private static final Logger log = LoggerFactory.getLogger(SHA256Util.class);

    public static boolean sha256SignVerify(String appSecret, HttpServletRequest request) {
        Map map = request.getParameterMap();
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : map.keySet()) {
            params.put(key, ((String[])map.get(key))[0]);
        }
        return SHA256Util.sha256SignVerify(appSecret, params);
    }

    public static boolean sha256SignVerify(String appSecret, Map<String, String> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : params.keySet()) {
            if (key.equals("sign") || key.toLowerCase().equals("appsecret")) continue;
            map.put(key, params.get(key));
        }
        map.put("appSecret", appSecret);
        String sign = SHA256Util.sha256Sign(map);
        log.info("sha256-sign1:{}, sign2:{}", (Object)sign, (Object)params.get("sign"));
        return sign.equals(params.get("sign"));
    }

    public static String sha256Sign(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : keys) {
            stringBuilder.append(params.get(s));
        }
        String sign = "";
        try {
            String src = stringBuilder.toString();
            sign = SHA256Util.sha256(src.getBytes());
        }
        catch (Exception e) {
            log.error("SHA-256 error", (Throwable)e);
            return "";
        }
        return sign;
    }

    private static String sha256(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return SHA256Util.bytesToHex(md.digest(data));
        }
        catch (Exception ex) {
            log.warn("Never happen.", (Throwable)ex);
            return null;
        }
    }

    private static String bytesToHex(byte[] bytes) {
        String hexArray = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int bi = b & 0xFF;
            sb.append(hexArray.charAt(bi >> 4));
            sb.append(hexArray.charAt(bi & 0xF));
        }
        return sb.toString();
    }
}

