/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.redis.impl;

import cn.com.duibabiz.component.redis.RedisCustomClient;
import cn.com.duibabiz.component.redis.RedisCustomClientProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.util.Assert;

public class RedisCustomClientImpl<K, V>
implements RedisCustomClient<K, V> {
    @Resource(name="redisTemplate")
    private RedisTemplate<K, V> redisTemplate;
    @Autowired
    private RedisCustomClientProperties properties;

    @Override
    public V get(Object key) {
        return (V)this.opsForValue().get(key);
    }

    @Override
    public List<V> multiGet(Collection<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyList();
        }
        Assert.isTrue((keys.size() <= this.properties.getKeysMax() ? 1 : 0) != 0, (String)"keys\u4e2a\u6570\u8d85\u8fc7\u6700\u5927\u503c");
        ArrayList<byte[]> result = new ArrayList<byte[]>(keys.size());
        int counter = 0;
        int index = 0;
        byte[][] rawKeys = this.getRawKeys(keys, counter);
        for (K hashKey : keys) {
            rawKeys[index] = this.rawKey(hashKey);
            if (++index != this.properties.getSplit() && ++counter != keys.size()) continue;
            index = 0;
            List<byte[]> rawValues = this.execute(rawKeys);
            result.addAll(rawValues);
            rawKeys = this.getRawKeys(keys, counter);
        }
        return this.deserializeValues(result);
    }

    private byte[][] getRawKeys(Collection<K> keys, int counter) {
        return new byte[Math.min(keys.size() - counter, this.properties.getSplit())][];
    }

    private List<byte[]> execute(byte[][] rawKeys) {
        return (List)this.redisTemplate.execute(connection -> connection.mGet(rawKeys), true);
    }

    @Override
    public Long increment(K key, long delta) {
        return this.opsForValue().increment(key, delta);
    }

    @Override
    public Double increment(K key, double delta) {
        return this.opsForValue().increment(key, delta);
    }

    @Override
    public Boolean expire(K key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire(key, timeout, unit);
    }

    @Override
    public void set(K key, V value, long timeout, TimeUnit unit) {
        this.opsForValue().set(key, value, timeout, unit);
    }

    @Override
    public Boolean setIfAbsent(K key, V value) {
        return this.opsForValue().setIfAbsent(key, value);
    }

    private byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        if (this.keySerializer() == null && key instanceof byte[]) {
            return (byte[])key;
        }
        return this.keySerializer().serialize(key);
    }

    private List<V> deserializeValues(List<byte[]> rawValues) {
        if (this.valueSerializer() == null) {
            return rawValues;
        }
        return SerializationUtils.deserialize(rawValues, (RedisSerializer)this.valueSerializer());
    }

    private RedisSerializer keySerializer() {
        return this.redisTemplate.getKeySerializer();
    }

    private RedisSerializer valueSerializer() {
        return this.redisTemplate.getValueSerializer();
    }

    private ValueOperations<K, V> opsForValue() {
        return this.redisTemplate.opsForValue();
    }
}

