/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.concurrent;

import cn.com.duiba.boot.perftest.PerfTestContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@ThreadSafe
public class BatchConsumeBlockingQueue<T> {
    private static final Logger logger = LoggerFactory.getLogger(BatchConsumeBlockingQueue.class);
    private LinkedBlockingQueue<T> queue4Normal;
    private LinkedBlockingQueue<T> queue4PerfTest;
    private final int batchSize;
    private final int maxWaitTimeMillis;
    private final Consumer<List<T>> asyncBatchConsumer;
    private volatile long lastConsumeTimeMillis4Normal = 0L;
    private volatile long lastConsumeTimeMillis4PerfTest = 0L;
    private Thread queueThread;
    private volatile boolean isStarted = false;

    public BatchConsumeBlockingQueue(int capacity, int batchSize, final int maxWaitTimeMillis, Consumer<List<T>> asyncBatchConsumer) {
        Assert.notNull(asyncBatchConsumer, (String)"batchConsumer must not be null");
        if (capacity <= 0) {
            this.queue4Normal = new LinkedBlockingQueue();
            this.queue4PerfTest = new LinkedBlockingQueue();
        } else {
            this.queue4Normal = new LinkedBlockingQueue(capacity);
            this.queue4PerfTest = new LinkedBlockingQueue(capacity);
        }
        this.batchSize = batchSize;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
        this.asyncBatchConsumer = asyncBatchConsumer;
        if (maxWaitTimeMillis > 0) {
            this.queueThread = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(maxWaitTimeMillis);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        if (Thread.currentThread().isInterrupted()) break;
                        try {
                            BlockingQueue queue = BatchConsumeBlockingQueue.this.determineQueue();
                            if (System.currentTimeMillis() - BatchConsumeBlockingQueue.this.getLastConsumeTimeMillis() >= (long)maxWaitTimeMillis && queue.size() > 0) {
                                BatchConsumeBlockingQueue.this.tryBatchConsumeDataWhenTimeout(queue);
                            }
                            PerfTestContext._setPerfTestMode(true);
                            try {
                                queue = BatchConsumeBlockingQueue.this.determineQueue();
                                if (System.currentTimeMillis() - BatchConsumeBlockingQueue.this.getLastConsumeTimeMillis() < (long)maxWaitTimeMillis || queue.size() <= 0) continue;
                                BatchConsumeBlockingQueue.this.tryBatchConsumeDataWhenTimeout(queue);
                            }
                            finally {
                                PerfTestContext._setPerfTestMode(false);
                            }
                        }
                        catch (Throwable e) {
                            logger.error("\u89e6\u53d1\u6d88\u8d39\u65f6\u53d1\u751f\u5f02\u5e38", e);
                        }
                    }
                }
            };
        }
    }

    public synchronized void start() {
        if (!this.isStarted) {
            this.isStarted = true;
            if (this.maxWaitTimeMillis > 0) {
                this.queueThread.start();
            }
        }
    }

    public synchronized void stop() {
        if (this.isStarted) {
            this.isStarted = false;
            if (this.maxWaitTimeMillis > 0) {
                this.queueThread.interrupt();
            }
        }
    }

    private BlockingQueue<T> determineQueue() {
        if (!this.isStarted) {
            throw new IllegalStateException("not started yet!");
        }
        return PerfTestContext.isCurrentInPerfTestMode() ? this.queue4PerfTest : this.queue4Normal;
    }

    private void setLastConsumeTimeMillis() {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            this.lastConsumeTimeMillis4PerfTest = System.currentTimeMillis();
        } else {
            this.lastConsumeTimeMillis4Normal = System.currentTimeMillis();
        }
    }

    private long getLastConsumeTimeMillis() {
        return PerfTestContext.isCurrentInPerfTestMode() ? this.lastConsumeTimeMillis4PerfTest : this.lastConsumeTimeMillis4Normal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBatchConsumeDataWhenExceedBatchSize(BlockingQueue<T> queue) {
        while (queue.size() >= this.batchSize) {
            ArrayList list = new ArrayList();
            BatchConsumeBlockingQueue batchConsumeBlockingQueue = this;
            synchronized (batchConsumeBlockingQueue) {
                if (queue.size() >= this.batchSize) {
                    queue.drainTo(list, this.batchSize);
                }
                this.setLastConsumeTimeMillis();
            }
            this.asyncBatchConsumer.accept(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBatchConsumeDataWhenTimeout(BlockingQueue<T> queue) {
        if (queue.size() >= 0) {
            ArrayList list = new ArrayList();
            BatchConsumeBlockingQueue batchConsumeBlockingQueue = this;
            synchronized (batchConsumeBlockingQueue) {
                if (queue.size() >= 0) {
                    queue.drainTo(list, this.batchSize);
                }
            }
            this.asyncBatchConsumer.accept(list);
        }
    }

    public boolean add(T t) {
        BlockingQueue<T> queue = this.determineQueue();
        boolean added = queue.add(t);
        if (added) {
            this.tryBatchConsumeDataWhenExceedBatchSize(queue);
        }
        return added;
    }

    public boolean offer(T t) {
        BlockingQueue<T> queue = this.determineQueue();
        boolean added = queue.offer(t);
        if (added) {
            this.tryBatchConsumeDataWhenExceedBatchSize(queue);
        }
        return added;
    }

    public void put(T t) throws InterruptedException {
        BlockingQueue<T> queue = this.determineQueue();
        queue.put(t);
        this.tryBatchConsumeDataWhenExceedBatchSize(queue);
    }

    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        BlockingQueue<T> queue = this.determineQueue();
        boolean added = queue.offer(t, timeout, unit);
        if (added) {
            this.tryBatchConsumeDataWhenExceedBatchSize(queue);
        }
        return added;
    }

    public int remainingCapacity() {
        return this.determineQueue().remainingCapacity();
    }

    public boolean addAll(Collection<? extends T> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        boolean modified = false;
        for (T t : c) {
            if (!this.add(t)) continue;
            modified = true;
        }
        return modified;
    }

    public int size() {
        return this.determineQueue().size();
    }

    public boolean isEmpty() {
        return this.determineQueue().isEmpty();
    }

    public boolean contains(Object o) {
        return this.determineQueue().contains(o);
    }

    public Iterator<T> iterator() {
        return this.determineQueue().iterator();
    }

    public Object[] toArray() {
        return this.determineQueue().toArray();
    }

    public T[] toArray(T[] a) {
        return this.determineQueue().toArray(a);
    }

    public String toString() {
        return this.determineQueue().toString();
    }
}

