/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.perftest;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class PerfTestUtils {
    public static final String PERF_TEST_KEY = "_duibaPerf";
    public static final String IS_PERF_TEST_MODE_HEADER_KEY = "isPerfTestMode";

    private PerfTestUtils() {
    }

    public static boolean isPerfTestRequest(HttpServletRequest request) {
        String perfTestHeader;
        boolean isTestMode = PerfTestUtils.isPerfTestFromParameter(request);
        if (!isTestMode && (perfTestHeader = request.getHeader(PERF_TEST_KEY)) != null && ("1".equals(perfTestHeader) || "true".equals(perfTestHeader))) {
            isTestMode = true;
        }
        if (!isTestMode && "true".equals(request.getHeader(IS_PERF_TEST_MODE_HEADER_KEY))) {
            isTestMode = true;
        }
        return isTestMode;
    }

    private static boolean isPerfTestFromParameter(HttpServletRequest request) {
        boolean isTestMode = false;
        String testInParameter = request.getParameter(PERF_TEST_KEY);
        if (testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))) {
            isTestMode = true;
        } else {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!PERF_TEST_KEY.equals(cookie.getName()) || !"1".equals(cookie.getValue()) && !"true".equals(cookie.getValue())) continue;
                    isTestMode = true;
                }
            }
        }
        return isTestMode;
    }
}

