package cn.com.duiba.boot.perftest;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class PerfTestUtils {
    private PerfTestUtils(){}

    public static final String PERF_TEST_KEY = "_duibaPerf";
    public static final String PERF_TEST_SCENE_ID_KEY = "_duibaPerfSceneId";

    public static final String IS_PERF_TEST_MODE_HEADER_KEY = "isPerfTestMode";

    /**
     * 检测到包含_duibaPerf=1参数的url(或cookie中有_duibaPerf=1,或header中包含_duibaPerf=1)则认为是压测请求
     * @param request
     * @return
     */
    public static boolean isPerfTestRequest(HttpServletRequest request){
        boolean isTestMode = isPerfTestFromParameter(request);

        if(!isTestMode){
            String perfTestHeader = request.getHeader(PERF_TEST_KEY);
            if(perfTestHeader != null && ("1".equals(perfTestHeader) || "true".equals(perfTestHeader))){
                isTestMode = true;
            }
        }

        if(!isTestMode && "true".equals(request.getHeader(IS_PERF_TEST_MODE_HEADER_KEY))){
            //feign 发起的http压测请求头中会带有isPerfTestMode=true
            isTestMode = true;
        }

        return isTestMode;
    }

    /**
     * 从request中获取压测场景id，压测场景ID可以在以下任一地方：
     * <br/>
     * 参数的url中带有 _duibaPerfSceneId=**
     * <br/>
     * cookie中有 _duibaPerfSceneId=**
     * <br/>
     * header中包含 _duibaPerfSceneId=**
     *
     * @param request
     * @return 压测场景ID，可能为null (如果没有压测标记，无论有没有压测场景ID，都返回null)
     */
    public static String getPerfTestSceneId(HttpServletRequest request){
        if(!isPerfTestRequest(request)){//如果没有压测标记，无论有没有压测场景ID，都返回null
            return null;
        }

        String sceneId = request.getParameter(PERF_TEST_SCENE_ID_KEY);

        if(StringUtils.isBlank(sceneId)){
            Cookie[] cookies = request.getCookies();
            if(cookies != null) {
                for (Cookie cookie : cookies) {
                    if(PERF_TEST_SCENE_ID_KEY.equals(cookie.getName())){
                        sceneId = cookie.getValue();
                    }
                }
            }
        }
        if(StringUtils.isBlank(sceneId)){
            sceneId = request.getHeader(PERF_TEST_SCENE_ID_KEY);
        }

        return sceneId;
    }

    private static boolean isPerfTestFromParameter(HttpServletRequest request){
        boolean isTestMode = false;
        String testInParameter = request.getParameter(PERF_TEST_KEY);
        if(testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))){
            isTestMode = true;
        }else{
            Cookie[] cookies = request.getCookies();
            if(cookies != null) {
                for (Cookie cookie : cookies) {
                    if(PERF_TEST_KEY.equals(cookie.getName()) && ("1".equals(cookie.getValue()) || "true".equals(cookie.getValue()))){
                        isTestMode = true;
                    }
                }
            }
        }

        return isTestMode;
    }
}
