/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.perftest;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerfTestContext {
    private static final Logger logger = LoggerFactory.getLogger(PerfTestContext.class);
    private static volatile boolean _perfDebug = false;
    private Boolean isPerfTestMode;
    private String sceneId;
    private StackTraceElement[] stackTraceElements;
    private long timestamp;

    private PerfTestContext() {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public StackTraceElement[] getStackTraceElements() {
        return this.stackTraceElements;
    }

    private PerfTestContext copy() {
        PerfTestContext copyValue = new PerfTestContext();
        copyValue.isPerfTestMode = this.isPerfTestMode;
        copyValue.sceneId = this.sceneId;
        copyValue.stackTraceElements = this.stackTraceElements;
        copyValue.timestamp = this.timestamp;
        return copyValue;
    }

    public static boolean isCurrentInPerfTestMode() {
        PerfTestContext c = (PerfTestContext)TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
        return c != null && c.isPerfTestMode != null && c.isPerfTestMode != false;
    }

    static String getCurrentSceneId() {
        PerfTestContext c = (PerfTestContext)TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
        if (c == null) {
            return null;
        }
        return c.sceneId;
    }

    static void markAsPerfTest(String sceneId) {
        PerfTestContext.set(true, sceneId);
    }

    static void markAsNormal() {
        PerfTestContext.set(false, null);
    }

    private static void set(boolean isPerfTestMode, String sceneId) {
        if (isPerfTestMode) {
            PerfTestContext c = new PerfTestContext();
            c.isPerfTestMode = true;
            c.sceneId = sceneId;
            if (_perfDebug) {
                c.stackTraceElements = Thread.currentThread().getStackTrace();
                c.timestamp = System.currentTimeMillis();
            }
            TransmittableThreadLocalHolder.threadLocal2PressureTest.set((Object)c);
        } else {
            TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
        }
    }

    public static void _setPerfTestMode(Boolean val) {
        if (val == null) {
            TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
            return;
        }
        PerfTestContext c = (PerfTestContext)TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
        if (c == null) {
            c = new PerfTestContext();
        }
        c.isPerfTestMode = val;
        if (_perfDebug && val.booleanValue()) {
            c.stackTraceElements = Thread.currentThread().getStackTrace();
            c.timestamp = System.currentTimeMillis();
        }
        TransmittableThreadLocalHolder.threadLocal2PressureTest.set((Object)c);
    }

    public static PerfTestContext _currentContext() {
        return (PerfTestContext)TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
    }

    public static void debugInfo(String typeName) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            Arrays.stream(Thread.currentThread().getStackTrace()).filter(x -> x.getClassName().startsWith("cn.com.duiba.")).forEach(x -> sb.append("\n\t").append(x.getClassName()).append(".").append(x.getMethodName()).append(":").append(x.getLineNumber()));
            logger.debug("Perf [{}] From {}", (Object)typeName, (Object)sb);
        }
    }

    private static class TransmittableThreadLocalHolder {
        protected static final TransmittableThreadLocal<PerfTestContext> threadLocal2PressureTest = new TransmittableThreadLocal<PerfTestContext>(){

            protected PerfTestContext copy(PerfTestContext parentValue) {
                return parentValue != null ? parentValue.copy() : null;
            }

            protected PerfTestContext childValue(PerfTestContext parentValue) {
                return parentValue != null ? parentValue.copy() : null;
            }
        };

        private TransmittableThreadLocalHolder() {
        }
    }
}

