package cn.com.duiba.boot.perftest;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;

public final class PerfTestContext {
    private static final Logger logger = LoggerFactory.getLogger(PerfTestContext.class);
    private PerfTestContext(){}

    private static class TransmittableThreadLocalHolder{
        protected static final TransmittableThreadLocal<Boolean> threadLocal2PressureTest = new TransmittableThreadLocal<Boolean>();
    }

    /**
     * 判断当前是否是压测请求
     *
     * @return
     */
    public static boolean isCurrentInPerfTestMode(){
        Boolean b = TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
        return b != null && b == true;
    }

    /**
     * 设置是否压测请求，框架使用者不应该调用此接口
     * @param val
     */
    public static void _setPerfTestMode(Boolean val) {
        if(val != null && val) {
            TransmittableThreadLocalHolder.threadLocal2PressureTest.set(val);
        }else{
            TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
        }
    }

    public static void debugInfo(String typeName){
        if (logger.isDebugEnabled()) {
            Arrays.stream(Thread.currentThread().getStackTrace()).filter(x->x.getClassName().startsWith("cn.com.duiba.")).forEach(x->
                    logger.debug("Perf {} From {}:{}:{}",typeName, x.getClassName(),x.getMethodName(),x.getLineNumber())
            );
        }
    }
}
