/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.perftest;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerfTestContext {
    private static final Logger logger = LoggerFactory.getLogger(PerfTestContext.class);

    private PerfTestContext() {
    }

    public static boolean isCurrentInPerfTestMode() {
        Boolean b = (Boolean)TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
        return b != null && b == true;
    }

    public static void _setPerfTestMode(Boolean val) {
        if (val != null && val.booleanValue()) {
            TransmittableThreadLocalHolder.threadLocal2PressureTest.set((Object)val);
        } else {
            TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
        }
    }

    public static void debugInfo(String typeName) {
        if (logger.isDebugEnabled()) {
            Arrays.stream(Thread.currentThread().getStackTrace()).filter(x -> x.getClassName().startsWith("cn.com.duiba.")).forEach(x -> logger.debug("Perf {} From {}:{}:{}", new Object[]{typeName, x.getClassName(), x.getMethodName(), x.getLineNumber()}));
        }
    }

    private static class TransmittableThreadLocalHolder {
        protected static final TransmittableThreadLocal<Boolean> threadLocal2PressureTest = new TransmittableThreadLocal();

        private TransmittableThreadLocalHolder() {
        }
    }
}

