package cn.com.duiba.boot.utils;

import javax.servlet.http.HttpServletRequest;

/**
 * HttpServletRequest工具类
 */
public final class RequestUtils {

    /**
     * 如果ContextPath为空，则返回request.getRequestURI()，否则返回request.getRequestURI()减去request.getContextPath()的部分;
     * <br/>
     * 比如http://localhost/context/getUser返回getUser（其中 /context 是 request.getContextPath() ）;
     * 比如http://localhost/getUser返回getUser
     *
     * @param request
     * @return
     */
    public static String getRequestPath(HttpServletRequest request){
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath != null && contextPath.length() > 0) {
            uri = uri.substring(contextPath.length());
        }

        return uri;
    }
}
