package cn.com.duiba.boot.cat;

import java.lang.annotation.*;

/**
 * 这个注解用于控制在记录远程调用时给监控名带上参数，请使用argIndexes来指定使用哪几个参数（会调用指定参数的toString方法并附加到`监控名`后面,多个用逗号隔开）
 * <br/>
 * 比如对于下面这个例子：
 * <pre>
 * #@AdvancedFeignClient
 * public RemoteUserService{
 *     #@CatWithArgs(argIndexes = 0)
 *     public User getUserByName(String name);
 * }
 * </pre>
 * 如果发生了如下调用：
 * <pre>
 *     remoteUserService.getUserByName("lucy");
 * </pre>
 * 则记录到cat的监控名为：
 * <pre>
 *      RemoteUserService.getUserByName(lucy)
 * </pre>
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Documented
public @interface CatWithArgs {

    /**
     * 需要附加进监控名的参数,从0开始
     * @return
     */
    int[] argIndexes();

}
