package cn.com.duiba.boot.utils;

import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

import java.lang.reflect.Field;

/**
 * 这个工具类用于获取经过spring代理的对象的原始对象。
 */
public final class AopTargetUtils {
    private AopTargetUtils(){}
    /**
     * 获取 目标对象
     * @param proxy 代理对象
     * @return
     * @throws Exception
     */
    public static <T> T getTarget(Object proxy) throws Exception {
        if(!AopUtils.isAopProxy(proxy)) {
            return (T)proxy;//不是代理对象
        }

        T target;
        if(AopUtils.isJdkDynamicProxy(proxy)) {
            target =  (T)getJdkDynamicProxyTargetObject(proxy);
        } else { //cglib
            target = (T)getCglibProxyTargetObject(proxy);
        }

        return target != null ? target : (T)proxy;
    }


    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);

        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);

        return ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
    }


    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        if(proxy instanceof Advised) {
            return ((Advised) proxy).getTargetSource().getTarget();
        }

        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy) h.get(proxy);

        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);

        return ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
    }

}
