package cn.com.duiba.boot.serializer;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import org.apache.commons.lang3.SerializationException;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

/**
 * 引流回归中的trace的Hessian2序列化和反序列化
 * Created by guoyanfei .
 * 2019-01-25 .
 */
public class Hessian2Serializer {

    private static final byte[] EMPTY_ARRAY = new byte[0];

    private Hessian2Serializer() {
    }

    /**
     * 反序列化
     *
     * @param bytes
     * @return
     */
    public static Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }

        if (bytes.length == 1) {
            throw new SerializationException("Cannot deserialize, bytes.length must be > 1");
        }

        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            Hessian2Input hessian2Input = new Hessian2Input(in);
            return hessian2Input.readObject();
        } catch (Exception ex) {
            throw new SerializationException("Cannot deserialize", ex);
        }
    }

    /**
     * 序列化
     *
     * @param object
     * @return
     */
    public static byte[] serialize(Object object) {
        if (object == null) {
            return EMPTY_ARRAY;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Hessian2Output hessian2Output = new Hessian2Output(out);
            hessian2Output.writeObject(object);
            hessian2Output.flush();
            return out.toByteArray();
        } catch (Exception ex) {
            throw new SerializationException("Cannot serialize", ex);
        }
    }
}
