package cn.com.duiba.boot.utils;

import com.google.common.base.Splitter;

import java.util.List;

/**
 * @author liuyao
 */
public class IpUtils {

    private static final int IP_LENGTH = 4;

    private static final Splitter IP_SPLITTER = Splitter.on(".").omitEmptyStrings().trimResults();

    public static long transformIpToLong(String ip){
        long temp = 0;
        int index = 0;
        List<String> ipInfos = IP_SPLITTER.splitToList(ip);
        if(ipInfos.size()!=IP_LENGTH){
            throw new IllegalArgumentException("IP("+ip+")解析异常");
        }
        for(String item:ipInfos){
            long ipItem = Long.parseLong(item);
            ipItem = ipItem << (3-index)*8;
            temp += ipItem;
            index++;
        }
        return temp;
    }

    public static String transformLongToIp(long ip){
        return (ip >> 24) +
                "." +
                ((ip & 0x00FFFFFF) >> 16) +
                "." +
                ((ip & 0x0000FFFF) >> 8) +
                "." +
                (ip & 0x000000FF);
    }

}
