/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.factories.ReflectionSerializerFactory;
import com.esotericsoftware.kryo.factories.SerializerFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer {
    private static final Logger log = LoggerFactory.getLogger(KryoSerializer.class);
    private static final int BUFFER_SIZE = 16384;
    private static final Class<?> ARRAY_AS_LIST = KryoSerializer.classForName("java.util.Arrays$ArrayList");
    private static final Class<?> UNMODIFIABLE_COLLECTION = KryoSerializer.classForName("java.util.Collections$UnmodifiableCollection");
    private static final Class<?> UNMODIFIABLE_LIST = KryoSerializer.classForName("java.util.Collections$UnmodifiableList");
    private static final Class<?> UNMODIFIABLE_MAP = KryoSerializer.classForName("java.util.Collections$UnmodifiableMap");
    private static final Class<?> UNMODIFIABLE_NAVIGABLEMAP = KryoSerializer.classForName("java.util.Collections$UnmodifiableNavigableMap");
    private static final Class<?> UNMODIFIABLE_NAVIGABLESET = KryoSerializer.classForName("java.util.Collections$UnmodifiableNavigableSet");
    private static final Class<?> UNMODIFIABLE_RANDOMACCESSLIST = KryoSerializer.classForName("java.util.Collections$UnmodifiableRandomAccessList");
    private static final Class<?> UNMODIFIABLE_SET = KryoSerializer.classForName("java.util.Collections$UnmodifiableSet");
    private static final Class<?> UNMODIFIABLE_SORTEDMAP = KryoSerializer.classForName("java.util.Collections$UnmodifiableSortedMap");
    private static final Class<?> UNMODIFIABLE_SORTEDSET = KryoSerializer.classForName("java.util.Collections$UnmodifiableSortedSet");
    private static final Class<?> GOOGLE_LISTS_ABSTRACTLISTWRAPPER = KryoSerializer.classForName("com.google.common.collect.Lists$AbstractListWrapper");
    private static final Class<?> GOOGLE_LISTS_CHARSEQUENCEASLIST = KryoSerializer.classForName("com.google.common.collect.Lists$CharSequenceAsList");
    private static final Class<?> GOOGLE_LISTS_ONEPLUSARRAYLIST = KryoSerializer.classForName("com.google.common.collect.Lists$OnePlusArrayList");
    private static final Class<?> GOOGLE_LISTS_PARTITION = KryoSerializer.classForName("com.google.common.collect.Lists$Partition");
    private static final Class<?> GOOGLE_LISTS_RANDOMACCESSLISTWRAPPER = KryoSerializer.classForName("com.google.common.collect.Lists$RandomAccessListWrapper");
    private static final Class<?> GOOGLE_LISTS_RANDOMACCESSPARTITION = KryoSerializer.classForName("com.google.common.collect.Lists$RandomAccessPartition");
    private static final Class<?> GOOGLE_LISTS_RANDOMACCESSREVERSELIST = KryoSerializer.classForName("com.google.common.collect.Lists$RandomAccessReverseList");
    private static final Class<?> GOOGLE_LISTS_REVERSELIST = KryoSerializer.classForName("com.google.common.collect.Lists$ReverseList");
    private static final Class<?> GOOGLE_LISTS_STRINGASIMMUTABLELIST = KryoSerializer.classForName("com.google.common.collect.Lists$StringAsImmutableList");
    private static final Class<?> GOOGLE_LISTS_TRANSFORMINGRANDOMACCESSLIST = KryoSerializer.classForName("com.google.common.collect.Lists$TransformingRandomAccessList");
    private static final Class<?> GOOGLE_LISTS_TRANSFORMINGSEQUENTIALLIST = KryoSerializer.classForName("com.google.common.collect.Lists$TransformingSequentialList");
    private static final Class<?> GOOGLE_LISTS_TWOPLUSARRAYLIST = KryoSerializer.classForName("com.google.common.collect.Lists$TwoPlusArrayList");
    private static ThreadLocal<Kryo> kryoThreadLocal = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo(){

            public Registration writeClass(Output output, Class type) {
                if (type == ARRAY_AS_LIST) {
                    type = ArrayList.class;
                } else if (type == UNMODIFIABLE_COLLECTION) {
                    type = ArrayList.class;
                } else if (type == UNMODIFIABLE_LIST) {
                    type = ArrayList.class;
                } else if (type == UNMODIFIABLE_MAP) {
                    type = HashMap.class;
                } else if (type == UNMODIFIABLE_NAVIGABLEMAP) {
                    type = ConcurrentSkipListMap.class;
                } else if (type == UNMODIFIABLE_NAVIGABLESET) {
                    type = ConcurrentSkipListSet.class;
                } else if (type == UNMODIFIABLE_RANDOMACCESSLIST) {
                    type = ArrayList.class;
                } else if (type == UNMODIFIABLE_SET) {
                    type = HashSet.class;
                } else if (type == UNMODIFIABLE_SORTEDMAP) {
                    type = ConcurrentSkipListMap.class;
                } else if (type == UNMODIFIABLE_SORTEDSET) {
                    type = ConcurrentSkipListSet.class;
                } else if (type == GOOGLE_LISTS_ABSTRACTLISTWRAPPER) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_CHARSEQUENCEASLIST) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_ONEPLUSARRAYLIST) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_PARTITION) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_RANDOMACCESSLISTWRAPPER) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_RANDOMACCESSPARTITION) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_RANDOMACCESSREVERSELIST) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_REVERSELIST) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_STRINGASIMMUTABLELIST) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_TRANSFORMINGRANDOMACCESSLIST) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_TRANSFORMINGSEQUENTIALLIST) {
                    type = ArrayList.class;
                } else if (type == GOOGLE_LISTS_TWOPLUSARRAYLIST) {
                    type = ArrayList.class;
                }
                return super.writeClass(output, type);
            }
        };
        kryo.setDefaultSerializer((SerializerFactory)new ReflectionSerializerFactory(CompatibleFieldSerializer.class));
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        return kryo;
    });

    private static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("{} class not found", (Object)className, (Object)e);
            return null;
        }
    }

    private KryoSerializer() {
    }

    public static Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Input input = new Input((InputStream)in, 16384);
        Object obj = kryo.readClassAndObject(input);
        input.close();
        return obj;
    }

    public static byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)out, 16384);
        kryo.writeClassAndObject(output, object);
        output.close();
        return out.toByteArray();
    }
}

