/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import com.google.common.base.Splitter;
import java.util.List;

public class IpUtils {
    private static final int IP_LENGTH = 4;
    private static final Splitter IP_SPLITTER = Splitter.on((String)".").omitEmptyStrings().trimResults();

    public static long transformIpToLong(String ip) {
        long temp = 0L;
        int index = 0;
        List ipInfos = IP_SPLITTER.splitToList((CharSequence)ip);
        if (ipInfos.size() != 4) {
            throw new IllegalArgumentException("IP(" + ip + ")\u89e3\u6790\u5f02\u5e38");
        }
        for (String item : ipInfos) {
            long ipItem = Long.parseLong(item);
            temp += (ipItem <<= (3 - index) * 8);
            ++index;
        }
        return temp;
    }

    public static String transformLongToIp(long ip) {
        return (ip >> 24) + "." + ((ip & 0xFFFFFFL) >> 16) + "." + ((ip & 0xFFFFL) >> 8) + "." + (ip & 0xFFL);
    }
}

