/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.netflix.eureka;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EurekaHttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaHttpUtils.class);
    private static final int NUMBER_OF_RETRIES = 5;
    private static final Splitter SPLITTER = Splitter.on((String)",");
    private static final CloseableHttpClient HTTP_CLIENT = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(150).setSocketTimeout(150).setConnectionRequestTimeout(100).build()).setMaxConnPerRoute(1).setMaxConnTotal(10).evictExpiredConnections().disableAutomaticRetries().disableCookieManagement().useSystemProperties().disableRedirectHandling().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            long time = super.getKeepAliveDuration(response, context);
            if (time == -1L) {
                time = 30000L;
            }
            return time;
        }
    }).build();

    public static List<String> getUpIpPorts(String eurekaServerUrl, String serviceId) {
        String registeredInfo = EurekaHttpUtils.getServiceRegisteredInfo(eurekaServerUrl, serviceId);
        JSONArray instaces = EurekaHttpUtils.parseInstancesArray(registeredInfo);
        if (instaces == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ipPorts = new ArrayList<String>();
        for (Object instace : instaces) {
            JSONObject inst = (JSONObject)instace;
            if (!"UP".equals(inst.getString("status"))) continue;
            String ip = inst.getString("ipAddr");
            int port = inst.getJSONObject("port").getIntValue("$");
            ipPorts.add(ip + ":" + port);
        }
        return ipPorts;
    }

    public static Map<String, JSONObject> getUpIpInstanceMap(String eurekaServerUrl, String serviceId) {
        String registeredInfo = EurekaHttpUtils.getServiceRegisteredInfo(eurekaServerUrl, serviceId);
        JSONArray instaces = EurekaHttpUtils.parseInstancesArray(registeredInfo);
        if (instaces == null) {
            return Collections.emptyMap();
        }
        HashMap<String, JSONObject> ipMetadataMap = new HashMap<String, JSONObject>();
        for (Object instace : instaces) {
            JSONObject inst = (JSONObject)instace;
            if (!"UP".equals(inst.getString("status"))) continue;
            String ip = inst.getString("ipAddr");
            ipMetadataMap.put(ip, inst);
        }
        return ipMetadataMap;
    }

    private static JSONArray parseInstancesArray(String registeredInfo) {
        if (StringUtils.isBlank((CharSequence)registeredInfo)) {
            return null;
        }
        JSONObject infoJSONObj = JSON.parseObject((String)registeredInfo);
        JSONObject applicationJSONObj = infoJSONObj.getJSONObject("application");
        return applicationJSONObj.getJSONArray("instance");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getServiceRegisteredInfo(String eurekaServerUrl, String serviceId) {
        if (StringUtils.isBlank((CharSequence)eurekaServerUrl)) {
            throw new RuntimeException("eureka\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List eurekaUrls = SPLITTER.splitToList((CharSequence)eurekaServerUrl);
        if (CollectionUtils.isEmpty((Collection)eurekaUrls)) {
            throw new RuntimeException("eureka\u5730\u5740\u9519\u8bef, eurekaServerUrl=" + eurekaServerUrl);
        }
        int retry = 0;
        while (true) {
            if (retry >= 5) {
                LOGGER.error("\u901a\u8fc7http\u65b9\u5f0f\u8c03\u7528eureka\u63a5\u53e3\u83b7\u53d6\u6ce8\u518c\u4fe1\u606f\u5f02\u5e38, \u91cd\u8bd55\u6b21\u540e\u4f9d\u7136\u5931\u8d25");
                return null;
            }
            String currentEurekaUrl = (String)eurekaUrls.get(retry % eurekaUrls.size());
            HttpGet getRequest = new HttpGet(currentEurekaUrl + "apps/" + serviceId);
            getRequest.addHeader("Accept", "application/json");
            getRequest.addHeader("Accept-Encoding", "gzip");
            try (CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)getRequest);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new Exception("status code = " + statusCode);
                }
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            catch (Exception e) {
                LOGGER.warn("\u901a\u8fc7http\u65b9\u5f0f\u8c03\u7528eureka\u63a5\u53e3\u83b7\u53d6\u6ce8\u518c\u4fe1\u606f\u5f02\u5e38, \u5e94\u7528\u540d\u79f0: {}, error msg: {}", (Object)serviceId, (Object)e.getMessage());
                ++retry;
                continue;
            }
            break;
        }
    }
}

