/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import cn.com.duiba.boot.utils.IpUtils;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    public static final String ANY_HOST = "0.0.0.0";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final RangeSet<Long> LAN_IP_RANGE_SET = TreeRangeSet.create();
    private static volatile String localIP = null;

    public static String getLocalIp() {
        return localIP;
    }

    private static void initLocalIp() {
        Enumeration<NetworkInterface> netInterfaces;
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidLocalAddress(localAddress)) {
                localIP = localAddress.getHostAddress();
                return;
            }
        }
        catch (Throwable e) {
            log.warn("Failed to retriving ip address, " + e.getMessage(), e);
        }
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error("getLocalIp error", (Throwable)e);
            return;
        }
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(58) != -1) continue;
                localIP = ip.getHostAddress();
                return;
            }
        }
    }

    private static void initLanIpRangeSet() {
        Range a = Range.closed((Comparable)Long.valueOf(IpUtils.transformIpToLong("10.0.0.0")), (Comparable)Long.valueOf(IpUtils.transformIpToLong("10.255.255.255")));
        Range b = Range.closed((Comparable)Long.valueOf(IpUtils.transformIpToLong("172.16.0.0")), (Comparable)Long.valueOf(IpUtils.transformIpToLong("172.31.255.255")));
        Range c = Range.closed((Comparable)Long.valueOf(IpUtils.transformIpToLong("192.168.0.0")), (Comparable)Long.valueOf(IpUtils.transformIpToLong("192.168.255.255")));
        LAN_IP_RANGE_SET.add(a);
        LAN_IP_RANGE_SET.add(b);
        LAN_IP_RANGE_SET.add(c);
    }

    private static boolean isValidLocalAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress() || !address.isSiteLocalAddress()) {
            return false;
        }
        if (address instanceof Inet6Address) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANY_HOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    public static boolean isLanIp(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return false;
        }
        long ipIndex = IpUtils.transformIpToLong(ip);
        return LAN_IP_RANGE_SET.contains((Comparable)Long.valueOf(ipIndex));
    }

    static {
        NetUtils.initLocalIp();
        NetUtils.initLanIpRangeSet();
    }
}

