/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance;

import cn.com.duiba.boot.ext.javaagent.plugin.AbstractClassEnhancePluginDefine;
import cn.com.duiba.boot.ext.javaagent.plugin.PluginException;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.ConstructorInterceptPoint;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.EnhanceException;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.StaticMethodsInterceptPoint;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.ConstructorInter;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.EnhancedInstance;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.InstMethodsInter;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.InstMethodsInterWithOverrideArgs;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.OverrideCallable;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.StaticMethodsInter;
import cn.com.duiba.boot.ext.javaagent.plugin.util.StringUtil;
import java.lang.reflect.Type;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ClassEnhancePluginDefine
extends AbstractClassEnhancePluginDefine {
    public static final String CONTEXT_ATTR_NAME = "_$EnhancedClassField_ws";

    @Override
    protected DynamicType.Builder<?> enhance(String enhanceOriginClassName, DynamicType.Builder<?> newClassBuilder, ClassLoader classLoader) throws PluginException {
        newClassBuilder = this.enhanceClass(enhanceOriginClassName, newClassBuilder, classLoader);
        newClassBuilder = this.enhanceInstance(enhanceOriginClassName, newClassBuilder, classLoader);
        return newClassBuilder;
    }

    private DynamicType.Builder<?> enhanceInstance(String enhanceOriginClassName, DynamicType.Builder<?> newClassBuilder, ClassLoader classLoader) throws PluginException {
        ConstructorInterceptPoint[] constructorInterceptPoints = this.getConstructorsInterceptPoints();
        InstanceMethodsInterceptPoint[] instanceMethodsInterceptPoints = this.getInstanceMethodsInterceptPoints();
        boolean existedConstructorInterceptPoint = false;
        if (constructorInterceptPoints != null && constructorInterceptPoints.length > 0) {
            existedConstructorInterceptPoint = true;
        }
        boolean existedMethodsInterceptPoints = false;
        if (instanceMethodsInterceptPoints != null && instanceMethodsInterceptPoints.length > 0) {
            existedMethodsInterceptPoints = true;
        }
        if (!existedConstructorInterceptPoint && !existedMethodsInterceptPoints) {
            return newClassBuilder;
        }
        newClassBuilder = newClassBuilder.defineField(CONTEXT_ATTR_NAME, Object.class, 2).implement(new Type[]{EnhancedInstance.class}).intercept((Implementation)FieldAccessor.ofField((String)CONTEXT_ATTR_NAME));
        if (existedConstructorInterceptPoint) {
            for (ConstructorInterceptPoint constructorInterceptPoint : constructorInterceptPoints) {
                newClassBuilder = newClassBuilder.constructor(constructorInterceptPoint.getConstructorMatcher()).intercept(SuperMethodCall.INSTANCE.andThen((Implementation)MethodDelegation.withDefaultConfiguration().to((Object)new ConstructorInter(constructorInterceptPoint.getConstructorInterceptor(), classLoader))));
            }
        }
        if (existedMethodsInterceptPoints) {
            for (InstanceMethodsInterceptPoint instanceMethodsInterceptPoint : instanceMethodsInterceptPoints) {
                String interceptor = instanceMethodsInterceptPoint.getMethodsInterceptor();
                if (StringUtil.isEmpty(interceptor)) {
                    throw new EnhanceException("no InstanceMethodsAroundInterceptor define to enhance class " + enhanceOriginClassName);
                }
                newClassBuilder = instanceMethodsInterceptPoint.isOverrideArgs() ? newClassBuilder.method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic()).and(instanceMethodsInterceptPoint.getMethodsMatcher())).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Morph.Binder.install(OverrideCallable.class)}).to((Object)new InstMethodsInterWithOverrideArgs(interceptor, classLoader))) : newClassBuilder.method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic()).and(instanceMethodsInterceptPoint.getMethodsMatcher())).intercept((Implementation)MethodDelegation.withDefaultConfiguration().to((Object)new InstMethodsInter(interceptor, classLoader)));
            }
        }
        return newClassBuilder;
    }

    protected abstract ConstructorInterceptPoint[] getConstructorsInterceptPoints();

    protected abstract InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints();

    private DynamicType.Builder<?> enhanceClass(String enhanceOriginClassName, DynamicType.Builder<?> newClassBuilder, ClassLoader classLoader) throws PluginException {
        StaticMethodsInterceptPoint[] staticMethodsInterceptPoints = this.getStaticMethodsInterceptPoints();
        if (staticMethodsInterceptPoints == null || staticMethodsInterceptPoints.length == 0) {
            return newClassBuilder;
        }
        for (StaticMethodsInterceptPoint staticMethodsInterceptPoint : staticMethodsInterceptPoints) {
            String interceptor = staticMethodsInterceptPoint.getMethodsInterceptor();
            if (StringUtil.isEmpty(interceptor)) {
                throw new EnhanceException("no StaticMethodsAroundInterceptor define to enhance class " + enhanceOriginClassName);
            }
            newClassBuilder = staticMethodsInterceptPoint.isOverrideArgs() ? newClassBuilder.method((ElementMatcher)ElementMatchers.isStatic().and(staticMethodsInterceptPoint.getMethodsMatcher())).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Morph.Binder.install(OverrideCallable.class)}).to((Object)new StaticMethodsInter(interceptor))) : newClassBuilder.method((ElementMatcher)ElementMatchers.isStatic().and(staticMethodsInterceptPoint.getMethodsMatcher())).intercept((Implementation)MethodDelegation.withDefaultConfiguration().to((Object)new StaticMethodsInter(interceptor)));
        }
        return newClassBuilder;
    }

    protected abstract StaticMethodsInterceptPoint[] getStaticMethodsInterceptPoints();
}

