/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance;

import cn.com.duiba.boot.ext.javaagent.plugin.PluginException;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.EnhancedInstance;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.loader.InterceptorInstanceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;

public class ConstructorInter {
    private static final Logger logger = Logger.getLogger(ConstructorInter.class.getName());
    private InstanceConstructorInterceptor interceptor;

    public ConstructorInter(String constructorInterceptorClassName, ClassLoader classLoader) throws PluginException {
        try {
            this.interceptor = (InstanceConstructorInterceptor)InterceptorInstanceLoader.load(constructorInterceptorClassName, classLoader);
        }
        catch (Throwable t) {
            throw new PluginException("Can't create InstanceConstructorInterceptor.", t);
        }
    }

    @RuntimeType
    public void intercept(@This Object obj, @AllArguments Object[] allArguments) {
        try {
            EnhancedInstance targetObject = (EnhancedInstance)obj;
            this.interceptor.onConstruct(targetObject, allArguments);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "ConstructorInter failure.", t);
        }
    }
}

