package cn.com.duiba.boot.ext.javaagent.plugin;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Plugins finder.
 * Use {@link PluginResourcesResolver} to find all plugins,
 * and ask {@link PluginCfg} to load all plugin definitions.
 *
 */
public class PluginBootstrap {
    private final Logger logger =  Logger.getLogger(PluginBootstrap.class.getName());

    /**
     * load all plugins.
     *
     * @return plugin definition list.
     */
    public List<AbstractClassEnhancePluginDefine> loadPlugins() {
        PluginResourcesResolver resolver = new PluginResourcesResolver();
        List<URL> resources = resolver.getResources();

        if (resources == null || resources.size() == 0) {
            logger.info("no plugin files (agent-plugin.def) found, continue to start application.");
            return new ArrayList<AbstractClassEnhancePluginDefine>();
        }

        for (URL pluginUrl : resources) {
            try {
                PluginCfg.INSTANCE.load(pluginUrl.openStream());
            } catch (Throwable t) {
                logger.log(Level.SEVERE, String.format("plugin file [%s] init failure.", pluginUrl),t);
            }
        }

        List<PluginDefine> pluginClassList = PluginCfg.INSTANCE.getPluginClassList();

        List<AbstractClassEnhancePluginDefine> plugins = new ArrayList<AbstractClassEnhancePluginDefine>();
        for (PluginDefine pluginDefine : pluginClassList) {
            try {
                if(logger.isLoggable(Level.FINE)) {
                    logger.fine("loading plugin class " + pluginDefine.getDefineClass());
                }

                AbstractClassEnhancePluginDefine plugin =

                    (AbstractClassEnhancePluginDefine) Class.forName(pluginDefine.getDefineClass()).newInstance();
                plugins.add(plugin);
            } catch (Throwable t) {
                logger.log(Level.SEVERE, String.format("load plugin [%s] failure.", pluginDefine.getDefineClass()),t);
            }
        }

        return plugins;

    }

}
