package cn.com.duiba.boot.ext.javaagent.plugin;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Use the current classloader to read all plugin define file.
 * The file must be named 'agent-plugin.def'
 *
 */
public class PluginResourcesResolver {
    private final Logger logger =  Logger.getLogger(PluginResourcesResolver.class.getName());

    public List<URL> getResources() {
        List<URL> cfgUrlPaths = new ArrayList<URL>();
        Enumeration<URL> urls;
        try {
            urls = getDefaultClassLoader().getResources("agent-plugin.def");

            while (urls.hasMoreElements()) {
                URL pluginUrl = urls.nextElement();
                cfgUrlPaths.add(pluginUrl);
                if(logger.isLoggable(Level.INFO)) {
                    logger.info("find agent plugin define in " + pluginUrl);
                }
            }

            return cfgUrlPaths;
        } catch (IOException e) {
            logger.log(Level.SEVERE,"read resources failure.", e);
        }
        return null;
    }

    /**
     * Get the classloader.
     * First get current thread's classloader,
     * if fail, get {@link PluginResourcesResolver}'s classloader.
     *
     * @return the classloader to find plugin definitions.
     */
    private ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        } catch (Throwable ex) {
            // Cannot access thread context ClassLoader - falling back to system class loader...
        }
        if (cl == null) {
            // No thread context class loader -> use class loader of this class.
            cl = PluginResourcesResolver.class.getClassLoader();
        }
        return cl;
    }

}
