/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.javaagent.plugin;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginResourcesResolver {
    private final Logger logger = Logger.getLogger(PluginResourcesResolver.class.getName());

    public List<URL> getResources() {
        ArrayList<URL> cfgUrlPaths = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = this.getDefaultClassLoader().getResources("agent-plugin.def");
            while (urls.hasMoreElements()) {
                URL pluginUrl = urls.nextElement();
                cfgUrlPaths.add(pluginUrl);
                if (!this.logger.isLoggable(Level.INFO)) continue;
                this.logger.info("find agent plugin define in " + pluginUrl);
            }
            return cfgUrlPaths;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "read resources failure.", e);
            return null;
        }
    }

    private ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = PluginResourcesResolver.class.getClassLoader();
        }
        return cl;
    }
}

