/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance;

import cn.com.duiba.boot.ext.javaagent.plugin.PluginException;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.EnhancedInstance;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.MethodInterceptResult;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.loader.InterceptorInstanceLoader;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;

public class InstMethodsInter {
    private static final Logger logger = Logger.getLogger(InstMethodsInter.class.getName());
    private InstanceMethodsAroundInterceptor interceptor;

    public InstMethodsInter(String instanceMethodsAroundInterceptorClassName, ClassLoader classLoader) {
        try {
            this.interceptor = (InstanceMethodsAroundInterceptor)InterceptorInstanceLoader.load(instanceMethodsAroundInterceptorClassName, classLoader);
        }
        catch (Throwable t) {
            throw new PluginException("Can't create InstanceMethodsAroundInterceptor.", t);
        }
    }

    @RuntimeType
    public Object intercept(@This Object obj, @AllArguments Object[] allArguments, @SuperCall Callable<?> zuper, @Origin Method method) throws Throwable {
        EnhancedInstance targetObject = (EnhancedInstance)obj;
        MethodInterceptResult result = new MethodInterceptResult();
        try {
            this.interceptor.beforeMethod(targetObject, method, allArguments, method.getParameterTypes(), result);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "class[" + obj.getClass() + "] before method[" + method.getName() + "] intercept failure", t);
        }
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call();
        }
        catch (Throwable t) {
            try {
                this.interceptor.handleMethodException(targetObject, method, allArguments, method.getParameterTypes(), t);
            }
            catch (Throwable t2) {
                logger.log(Level.SEVERE, "class[" + obj.getClass() + "] handle method[" + method.getName() + "] exception failure", t2);
            }
            throw t;
        }
        finally {
            try {
                ret = this.interceptor.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "class[" + obj.getClass() + "] after method[" + method.getName() + "] intercept failure", t);
            }
        }
        return ret;
    }
}

