/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance;

import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.MethodInterceptResult;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.OverrideCallable;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.loader.InterceptorInstanceLoader;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;

public class StaticMethodsInterWithOverrideArgs {
    private static final Logger logger = Logger.getLogger(StaticMethodsInterWithOverrideArgs.class.getName());
    private String staticMethodsAroundInterceptorClassName;

    public StaticMethodsInterWithOverrideArgs(String staticMethodsAroundInterceptorClassName) {
        this.staticMethodsAroundInterceptorClassName = staticMethodsAroundInterceptorClassName;
    }

    @RuntimeType
    public Object intercept(@Origin Class<?> clazz, @AllArguments Object[] allArguments, @Origin Method method, @Morph OverrideCallable zuper) throws Throwable {
        StaticMethodsAroundInterceptor interceptor = (StaticMethodsAroundInterceptor)InterceptorInstanceLoader.load(this.staticMethodsAroundInterceptorClassName, clazz.getClassLoader());
        MethodInterceptResult result = new MethodInterceptResult();
        try {
            interceptor.beforeMethod(clazz, method, allArguments, method.getParameterTypes(), result);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "class[" + clazz + "] before static method[" + method.getName() + "] intercept failure");
        }
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call(allArguments);
        }
        catch (Throwable t) {
            try {
                interceptor.handleMethodException(clazz, method, allArguments, method.getParameterTypes(), t);
            }
            catch (Throwable t2) {
                logger.log(Level.SEVERE, "class[" + clazz + "] handle static method[" + method.getName() + "] exception failure", t2);
            }
            throw t;
        }
        finally {
            try {
                ret = interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "class[" + clazz + "] after static method[" + method.getName() + "] failure", t);
            }
        }
        return ret;
    }
}

