/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.catmonitor.mybatis.CatMybatisPlugin;
import cn.com.duiba.catmonitor.springboot.WebConfig;
import javax.servlet.Servlet;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={WebConfig.class, Servlet.class})
@ConditionalOnWebApplication
public class CatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WebConfig.class, FilterRegistrationBean.class})
    public WebConfig catConfigurer() {
        return new WebConfig();
    }

    @Bean
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class})
    public BeanPostProcessor myBatisPostProcessorConfigurer() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                SqlSessionFactory s = null;
                if (bean instanceof SqlSessionFactory) {
                    s = (SqlSessionFactory)bean;
                }
                if (bean instanceof SqlSessionTemplate) {
                    s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
                }
                boolean hasCatPlugin = false;
                for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                    if (!(plugin instanceof CatMybatisPlugin)) continue;
                    hasCatPlugin = true;
                    break;
                }
                if (!hasCatPlugin) {
                    s.getConfiguration().addInterceptor((Interceptor)new CatMybatisPlugin());
                }
                return bean;
            }
        };
    }
}

