package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.catmonitor.mybatis.CatMybatisPlugin;
import cn.com.duiba.catmonitor.springboot.WebConfig;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import javax.servlet.Servlet;

/**
 * Created by wenqi.huang on 2016/11/7.
 */
@Configuration
@ConditionalOnClass({WebConfig.class, Servlet.class})
@ConditionalOnWebApplication
public class CatAutoConfiguration {

    /**
     * 注入cat监控的Filter
     * @return
     */
    @Bean
    @ConditionalOnMissingBean({WebConfig.class, FilterRegistrationBean.class})
    public WebConfig catConfigurer(){
        return new WebConfig();
    }

    /**
     * 声明后置处理器，spring全部bean初始化完成后调用，给所有SqlSessionBean注入CatMybatisPlugin plugin，监控sql的执行
     * @return
     */
    @Bean
    @ConditionalOnClass({SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class})
    public BeanPostProcessor myBatisPostProcessorConfigurer(){
        return new BeanPostProcessor() {
            @Override
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                SqlSessionFactory s = null;
                if(bean instanceof SqlSessionFactory){
                    s = (SqlSessionFactory)bean;
                }
                if(bean instanceof SqlSessionTemplate){
                    s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
                }
                boolean hasCatPlugin = false;
                if(s.getConfiguration() != null && s.getConfiguration().getInterceptors() != null && !s.getConfiguration().getInterceptors().isEmpty()) {
                    for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                        if (plugin instanceof CatMybatisPlugin) {
                            hasCatPlugin = true;
                            break;
                        }
                    }
                }else{
                }

                if (!hasCatPlugin) {
                    s.getConfiguration().addInterceptor(new CatMybatisPlugin());
                }

                return bean;
            }
        };
    }

}
