/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.mybatis;

import cn.com.duiba.boot.ext.autoconfigure.mybatis.SpringBootVFS;
import java.lang.reflect.Method;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, VFS.class})
    public static class MyBatisPostProcessorConfiguration {
        @Bean
        public BeanPostProcessor myBatisPostProcessorConfigurer() {
            boolean hasVfsMethod = false;
            try {
                Method m = SqlSessionFactoryBean.class.getMethod("getVfs", new Class[0]);
                hasVfsMethod = true;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            final boolean hasVfsMethodFinal = hasVfsMethod;
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    SqlSessionFactoryBean f;
                    if (hasVfsMethodFinal && bean instanceof SqlSessionFactoryBean && (f = (SqlSessionFactoryBean)bean).getVfs() == null) {
                        f.setVfs(SpringBootVFS.class);
                    }
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }
            };
        }
    }
}

