/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.test;

import cn.com.duiba.boot.ext.autoconfigure.core.ttl.TransmittableExecutorBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.test.TestRoutingDataSource;
import com.alibaba.ttl.TransmittableThreadLocal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@ConditionalOnClass(value={TransmittableThreadLocal.class})
public class PressureTestAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={AbstractRoutingDataSource.class, TransmittableThreadLocal.class})
    public static class DataSourceConfigurer {
        @Bean
        public BeanPostProcessor dataSourcePostProcessor() {
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    if (bean instanceof DataSource && !(bean instanceof TestRoutingDataSource)) {
                        TestRoutingDataSource ts = new TestRoutingDataSource((DataSource)bean);
                        ts.afterPropertiesSet();
                        bean = ts;
                    }
                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    public static class TransmittableThreadLocalConfigurer {
        @Bean
        public BeanPostProcessor executorServiceBeanPostProcessor() {
            return new TransmittableExecutorBeanPostProcessor();
        }
    }

    @Configuration
    public static class WebConfiguration
    extends WebMvcConfigurerAdapter {
        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor(this.pressureTestInterceptor()).addPathPatterns(new String[]{"/**"});
        }

        private HandlerInterceptor pressureTestInterceptor() {
            return new HandlerInterceptorAdapter(){

                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
                    TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
                    String test = request.getParameter("_test");
                    if (test != null && ("1".equals(test) || "true".equals(test))) {
                        TransmittableThreadLocalHolder.threadLocal2PressureTest.set((Object)true);
                    }
                    return true;
                }

                public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
                    TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
                }
            };
        }
    }

    public static class TransmittableThreadLocalHolder {
        protected static final TransmittableThreadLocal<Boolean> threadLocal2PressureTest = new TransmittableThreadLocal();
    }
}

