package cn.com.duiba.boot.ext.autoconfigure.memcached;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Created by wenqi.huang on 2016/11/4.
 */
@ConfigurationProperties(prefix = "duiba.memcached")
public class MemcachedProperties {
    /**
     * 服务器地址，多个用,隔开，使用memcached时。这个是必须参数
     */
    private String servers;
    /**
     * 用户名
     */
    private String username;
    /**
     * 密码
     */
    private String password;
    /**
     * 如果配置了多个服务器地址，且每个服务器的用户名密码不相同，则需要配置此参数，格式：   username1:password1,username2:password2
     */
    private String authInfos;

    /**
     * 协议：TEXT / BINARY，默认BINARY
     */
    private String protocol;

    /**
     * 是否启用心跳，默认启用
     */
    private Boolean enableHeartBeat = false;

    /**
     * 设置memcached连接池大小
     */
    private Integer connectionPoolSize = 1;

    public String getServers() {
        return servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthInfos() {
        return authInfos;
    }

    public void setAuthInfos(String authInfos) {
        this.authInfos = authInfos;
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Boolean getEnableHeartBeat() {
        return enableHeartBeat;
    }

    public void setEnableHeartBeat(Boolean enableHeartBeat) {
        this.enableHeartBeat = enableHeartBeat;
    }

    public Integer getConnectionPoolSize() {
        return connectionPoolSize;
    }

    public void setConnectionPoolSize(Integer connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }
}
