package cn.com.duiba.boot.ext.autoconfigure.test;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;

/**
 * Created by wenqi.huang on 2016/11/24.
 */
@Activate(group={"consumer","provider"},order = 0)
public class DubboPerfTestFilter implements Filter {

    private static final String IS_PERF_TEST_MODE = "isPerfTestMode";

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcContext context = RpcContext.getContext();
        if(context.isConsumerSide()) {
            Boolean isTestMode = PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
            if (isTestMode != null && isTestMode == true) {
                context.setAttachment(IS_PERF_TEST_MODE, "true");//这个标记在dubbo请求完毕后会自动清空
            }
        }else{
            String val = context.getAttachment(IS_PERF_TEST_MODE);
            if("true".equals(val)){
                PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.set(true);
            }
        }

        Result result = null;
        try {
            result = invoker.invoke(invocation);
        }finally {
            if(context.isProviderSide()) {
                PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
            }
        }
        return result;
    }
}
