package cn.com.duiba.boot.ext.autoconfigure.logger;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * 日志工厂类
 * @author xugf create by 2016-12-01
 *
 */
public class DuiBaLoggerFactory {
	
	private static final ConcurrentMap<String, DuibaLoggerImpl> loggers = new ConcurrentHashMap<String, DuibaLoggerImpl>();
	
	public static DuiBaLogger getLogger(Class<?> key) {
		DuibaLoggerImpl logger = loggers.get(key.getName());
		if(logger == null){
			loggers.putIfAbsent(key.getName(), new DuibaLoggerImpl(key.getName()));
			logger = loggers.get(key.getName());
		}
		return logger;
	}
	
}
